# Quick Reference Card

## File Locations

| File | Purpose |
|------|---------|
| `teams_rgb_correct.csv` | **Current CSV** with espn_team_id column |
| `gl_common.jsxinc` | **Shared JSX library** - all GL.* functions |
| `_python_runner_template.py` | **Template** for new animations |
| `REFACTORING_GUIDE.md` | **Full documentation** |
| `CHANGES_SUMMARY.md` | **Summary of changes** |
| `Originals_Backup_20251014_224126/` | **Backup folder** (restore if needed) |

---

## Run an Animation

```bash
cd "/Users/zacharyladonis/Documents/GLANCE/Scoring Animations"
python run_TdAnimation3.py       # Touchdown Animation 3
python run_FgAnimation3.py       # Field Goal Animation 3
python run_HomerunAnimation1.py  # Home Run Animation 1
```

---

## Output Folder Structure

```
{AnimationType}_Animation_{Number}_{Resolution}/
  └── {LEAGUE}/
      └── {LEAGUE}_{ESPN_ID}_{ABBR}_{ANIM_NAME}/
          └── (PNG sequence or MP4 files)
```

**Example:**
```
TD_Animation_3_384/
  └── NFL/
      └── NFL_2_BUF_TD_2_6/    ← ESPN ID 2 = Buffalo Bills
          └── 00000.png
          └── 00001.png
          └── ...
```

---

## Key Changes

| Item | Old | New |
|------|-----|-----|
| **CSV File** | teams_rgb.csv | teams_rgb_correct.csv ✅ |
| **Output Path** | LEAGUE_**CONFERENCE**_ABBR | LEAGUE_**ESPN_ID**_ABBR ✅ |
| **JSX Library** | Inline code | gl_common.jsxinc ✅ |
| **Python Structure** | Inconsistent | Standardized template ✅ |

---

## Create New Animation

1. **Copy template:**
   ```bash
   cp _python_runner_template.py run_MyAnimation.py
   ```

2. **Edit these lines in run_MyAnimation.py:**
   ```python
   PROJECT   = "path/to/YourProject.aep"
   JSX_BATCH = "path/to/batch_YourScript.jsx"
   COMP      = "YourCompName"
   ANIM_NAME = "YOUR_ANIM_1_3"
   OUTDIR    = "path/to/output/folder"
   LEAGUE    = "NFL"  # or MLB, NBA, NHL, CFB
   ```

3. **Your JSX script structure:**
   ```javascript
   // 1. Load GL library
   (function(){
     var COMMON = $.getenv("AE_COMMON_JSX") || "";
     if (COMMON) { $.evalFile(File(COMMON)); }
     if (!$.global.GL) throw new Error("Library not loaded");
   })();
   var GL = $.global.GL;

   // 2. Read CSV and build teams
   var rows = GL.parseCSV(GL.openRead(CSV_PATH));
   var teams = GL.buildTeams(rows, LEAGUE);
   var todo = GL.pickTeamsLeagueOnly(teams, LEAGUE);

   // 3. Render loop
   for (var i=0; i<todo.length; i++){
     var t = todo[i];

     // Apply team colors/logos here

     // Generate output path with ESPN ID
     var lc = GL.leagueAndConfForPath(t.league, t.conference);
     var paths = GL.outPaths(rootOut, PATH_TPL, lc.base, t.abbr,
                             ANIM_NAME, lc.conf, t.espn_team_id);

     // Render
     GL.rqRenderTo(comp, RS_TPL, OM_TPL, paths.file);
   }
   ```

---

## Common GL Functions

| Function | Purpose |
|----------|---------|
| `GL.buildTeams(rows, defaultLeague)` | Parse CSV into team objects |
| `GL.pickTeamsLeagueOnly(teams, league)` | Filter teams by league |
| `GL.computeSmartColors(primary, secondary)` | Handle black/similar colors |
| `GL.replaceLogo(comp, layerName, league, abbr, opts)` | Replace team logo |
| `GL.setTextOrFillColor(layer, color)` | Set text color |
| `GL.setSolidColor(layer, color)` | Set solid layer color |
| `GL.setTintBothColorsDeep(layer, color, force100, depth)` | Set tint effect recursively |
| `GL.outPaths(rootOut, tpl, league, abbr, anim, conf, teamId)` | Generate output paths |
| `GL.rqRenderTo(comp, rsTpl, omTpl, outFile)` | Add to render queue and render |

---

## ESPN Team ID Examples

| Team | Abbr | ESPN ID |
|------|------|---------|
| Buffalo Bills | BUF | 2 |
| Dallas Cowboys | DAL | 6 |
| Philadelphia Eagles | PHI | 21 |
| Arizona Cardinals (NFL) | ARI | 22 |
| Arizona Diamondbacks (MLB) | ARI | 29 |

*Full list in `teams_rgb_correct.csv`*

---

## Troubleshooting

### Output folder uses conference instead of ESPN ID
→ Make sure your JSX passes `t.espn_team_id` as the **last parameter** to `GL.outPaths()`

### Error: "Common library not loaded"
→ Python runner missing: `"AE_COMMON_JSX": COMMON_JSX` in env dictionary

### Wrong CSV file being used
→ Check Python runner has: `CSV_PATH = ".../teams_rgb_correct.csv"`

### Script can't find files
→ Verify all paths in Python runner are absolute, not relative

---

## Rollback

```bash
# Restore one file
cp "Originals_Backup_20251014_224126/filename.py" ./

# Restore all
cp Originals_Backup_20251014_224126/* ./
```

---

**Last Updated:** October 14, 2025
**Version:** 2.0
